/*
 * TestMapArea.h
 *
 * Created 8/14/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/14/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef TEST_MAP_AREA_H
 #define TEST_MAP_AREA_H
 
 template <typename T> class TestMapArea;
 
 #include "global.h"
 #include "MapArea.h"
 #include "collisionPlane.h"
 
 // For texturing
 #include "pnmImage.h"
 #include "texture.h"
 #include "texturePool.h"
 
 // For safety, remember to undefine these macros at the end of this file
 #define HEIGHT_FIELD_DIRECTORY (global::_file_dir + "/height_map/crackles.png")
 #define GROUND_TEXTURE_DIRECTORY (global::_file_dir + "/height_map/crackles_ground.png")
 #define TERRAIN_SCALE 1.0f
 
 /**
  * Class specification for TestMapArea
  */
 template <typename T>
 class TestMapArea : public MapArea<T>
 {
 // Data Members
 protected:
 
 // Local Functions
 public:
    TestMapArea( NodePath& parent, const NodePath& focal_point = global::_world_Ptr->get_camera(), const std::string& name = "TestMapArea" );
    TestMapArea( const TestMapArea<T>& tma );
    virtual ~TestMapArea();
    inline TestMapArea<T>& operator=( const TestMapArea<T>& tma );
    virtual inline void populate_map_area( WindowFramework& window );
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 TestMapArea<T>::TestMapArea( NodePath& parent, const NodePath& focal_point, const std::string& name )
                : MapArea<T>( parent, focal_point, name, HEIGHT_FIELD_DIRECTORY )
 {
    _terrain.get_root().set_color( 0.55f, 0.4f, 0.4f );
    _terrain.get_root().set_pos( -100.0f, -100.0f, ZERO );
    //_terrain.get_root().reparent_to( window.get_render() );
    
    _terrain.get_root().set_scale( TERRAIN_SCALE );
    _terrain.get_root().set_sz( 1.3f * _terrain.get_root().get_sz() );
    MapArea<T>::set_boundaries( 513.0f, 513.0f ); // this has to occur after positioning and scaling of _terrain.get_root()
    
    // texture the terrain
    //PNMImage pnm_image( GROUND_TEXTURE_DIRECTORY );
    //PT(Texture) terrain_texture_Ptr( new Texture( "TestMapArea Texture" ) );
    //terrain_texture_Ptr->set_anisotropic_degree( 4 ); // this function unloads the texture if the texture is already loaded
    //terrain_texture_Ptr->load( pnm_image );
    
    PT(Texture) terrain_texture_Ptr( TexturePool::load_texture( GROUND_TEXTURE_DIRECTORY ) );
    
    //PT(TextureStage) ts_Ptr( new TextureStage( "ts" ) );
    //ts_Ptr->set_mode( TextureStage::M_normal ); //M_modulate_gloss );
    //_terrain.get_root().set_tex_gen( ts_Ptr, RenderAttrib::M_off ); //RenderAttrib::M_eye_sphere_map );
    // Need to provide lighting before using this
    //_terrain.get_root().set_normal_map( terrain_texture_Ptr, "Normal Map Texture", true );
    
    _terrain.get_root().set_texture( terrain_texture_Ptr );
    //_terrain.get_root().set_tex_scale( TextureStage::get_default(), 50.0f );
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 TestMapArea<T>::TestMapArea( const TestMapArea<T>& tma )
            : MapArea<T>( tma )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 TestMapArea<T>::~TestMapArea()
 {
    // if using CollisionHandlerEventNode directly, remember to call remove_node() to
    // avoid memory leaks
 }
 
 /**
  * operator=() copies the content of the specified TestMapArea to this TestMapArea.
  *
  * @param (const TestMapArea<T>&) tma
  * @return TestMapArea<T>&
  */
 template <typename T>
 inline TestMapArea<T>& TestMapArea<T>::operator=( const TestMapArea<T>& tma )
 {
    MapArea<T>::operator=( tma );
    
    return *this;
 }
 
 /**
  * populate_map_area() fills this TestMapArea with objects.
  *
  * @param (WindowFramework&) window
  */
 template <typename T>
 inline void TestMapArea<T>::populate_map_area( WindowFramework& window )
 {
    // load a Ralph character
    PT(Ralph<T>) ralph_Ptr( new Ralph<T>() );
    
    ralph_Ptr->load_model( window, window.get_render() );//, _terrain.get_root() );
    //ralph_Ptr->walk_forward();
    //ralph_Ptr->assign_interval( window );
    ralph_Ptr->set_pos( 5, 10, ZERO );
    //ralph_Ptr->look_at( *global::_player_1_Ptr, ZERO, ZERO, ZERO );
    //global::_player_1_Ptr->look_at( *ralph_Ptr, ZERO, ZERO, ZERO );
    
    add_object( ralph_Ptr );
    //global::_object_collection.add( ralph_Ptr );
    
    //ralph_Ptr->turn_off_collision();
    //ralph_Ptr->turn_on_collision();
    //ObjectCollection< PRIMARY_TYPE >::iterator itr( global::_object_collection.begin() );
    //itr->set_x( 10.0f );
    
    //printf( "Player 1: %1d\n", global::_player_1_Ptr->get_key() );
    //printf( "Ralph: %1d\n", ralph_Ptr->get_key() );
    
    /*for ( size_t i(0); i < 500; ++i )
    {
        PT( Ralph< PRIMARY_TYPE > ) model_Ptr( new Ralph< PRIMARY_TYPE >() );
        model_Ptr->load_model( window );
        
        add_object( model_Ptr );
        remove_object( model_Ptr );
    }
    //global::_object_collection.clear();*/
 }
 
 /** FRIEND FUNCTIONS **/
 
 #undef HEIGHT_FIELD_DIRECTORY
 #undef GROUND_TEXTURE_DIRECTORY
 #undef TERRAIN_SCALE
 
 #endif // TEST_MAP_AREA_H